﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.Links;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VIMT.VIASchedulingService.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.MakeAppointment
{
    public class SendProviderSideToEcStep : FilterBase<MakeAppointmentStateObject>
    {
        public override void Execute(MakeAppointmentStateObject state)
        {
            if (state.ProEcRequest == null)
                return;
            if (!string.IsNullOrEmpty(state.VistaFakeResponseType))
            {
                state.ProEcResponse = VistaFakeResponses.FakeMakeProAppointmentSuccessResponse(state);
                return;
            }

            var timer = new Stopwatch();
            timer.Start();
            state.ProEcResponse = state.ProEcRequest.SendReceive<VIMTVIASchdMakeApptmakeAppointmentResponse>(MessageProcessType.Local);
            timer.Stop();
            state.EcProcessingTimeMs += (int)timer.ElapsedMilliseconds;
        }
    }
}
